require( "scripts/style.lua" );



TitleFont = {
  standardFont,
  70,
  BlackColor
};


MakeDialog
{
    -- Name the modal dialog
    name="creditswindow",
    Bitmap
    {
        image="backgrounds/credits_background",

        Text
        {
            font = TitleFont,
            name = "title",
            x=kCenter,y=60,w=kMax ,h=75,
            flags = kHAlignCenter + kVAlignTop,
            label = "credits"
        };

        CreditsWindow
        {
            x = 110, y = 143,
            w = 572, h = 386,
            font = standardFont,
            fontsize = 16,
            fontcolor = BlackColor,
            headercolor = DarkBlueColor,
            speed = 40,         -- Time to play credits in milliseconds
            intropause = 1500,  -- Time to pause credits at start, in ms
            file = "credits/credits.txt",
        },

        Text
        {
            flags=kHAlignCenter + kVAlignTop,
            x=0,y=-22,
            w=kMax;h=39;
            label="#"..GetString("version",GetConfig(kGameVersion)) ;
        };
        Button
        {
            x=kCenter,
            y=kMax-65,
            graphics = StButtonGraphicsSm,
            font = MenuButtonFont;
            name="back",
            label="back",
            type = kPush,
            flags = kHAlignCenter + kVAlignCenter,
            scale = 0.8,
            command =
                function()
                    PopModal("creditswindow");
                end
        };
    },
}